#version 130

#define SSAO se= ep+ddd*sign (dot (ray,norm))*ray; occluderFragment = texture(texture2d2,se.xy); shadow=occluderFragment.w;occluderFragment.a=texture (texturedepth,se.xy).x;occNorm = (occluderFragment.xyz*2.0)-vec3 (1.0);depthDifference = 40.0*(depth-occluderFragment.a);normDiff = 1.0-1.0*dot(occNorm,norm); addition=step(0.00002,depthDifference)*normDiff*(1.0-smoothstep(0.0002,0.20,depthDifference)); bl += addition;

uniform sampler2D texture2d;
uniform sampler2D texture2dOther;
uniform sampler2D moon;
uniform sampler2D texture2d2;
uniform sampler2D texture2d3;
uniform sampler2D texturedepth;
uniform sampler2D texture2dOtherdepth;

varying vec2 UV;
varying vec4 Color;
uniform mat4 MV;
uniform mat4 MP;
uniform float k0;
uniform float k1;
uniform float k2;
uniform float ttime;
uniform float fttime;
uniform float TheType;

vec3 iResolution = vec3(1920.0, 1080.0, 0.0);

//#include "shaders/f_include_noiseother.cpp"
// hash

float hash(float n)
{
	return fract(sin(n) * 43758.5453);
}

vec3 hash3(vec2 p) {
	vec3 q = vec3(dot(p, vec2(127.1, 311.7)),
		dot(p, vec2(269.5, 183.3)),
		dot(p, vec2(419.2, 371.9)));
	return fract(sin(q) * 43758.5453);
}
// noise
float iqnoise(in vec2 x, float u, float v) {
	vec2 p = floor(x);
	vec2 f = fract(x);

	float k = 1.0 + 63.0 * pow(1.0 - v, 4.0);

	float va = 0.0;
	float wt = 0.0;
	for (int j = -2; j <= 2; j++)
		for (int i = -2; i <= 2; i++)
		{
			vec2 g = vec2(float(i), float(j));
			vec3 o = hash3(p + g) * vec3(u, u, 1.0);
			vec2 r = g - f + o.xy;
			float d = dot(r, r);
			float ww = pow(1.0 - smoothstep(0.0, 1.414, sqrt(d)), k);
			va += o.z * ww;
			wt += ww;
		}

	return va / wt;
}

float Shadow(sampler2D samp, vec2 UV) {

	if (ttime >= 257.0)
		return 1.0;

	float fwcurrent = texture(samp, UV.xy).x;
	float cl = 1;
	float coun = 0;
	float tot = 0;
	for (int ry = -5; ry < 5; ry++)
		for (int rx = -5; rx < 5; rx++)
		{

			vec2 pr = 0.002 * vec2(rx - 3.0, ry);
			if (texture(samp, UV.xy + pr).w < fwcurrent - 0.00001) {
				cl *= 0.983;
				//	cl = vec4(1, 0, 0, 1);
			}

		}

	return cl;

};



vec3 rgb2hsv(vec3 c)
{
	vec4 K = vec4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);
	vec4 p = mix(vec4(c.bg, K.wz), vec4(c.gb, K.xy), step(c.b, c.g));
	vec4 q = mix(vec4(p.xyw, c.r), vec4(c.r, p.yzx), step(p.x, c.r));

	float d = q.x - min(q.w, q.y);
	float e = 1.0e-10;
	return vec3(abs(q.z + (q.w - q.y) / (6.0 * d + e)), d / (q.x + e), q.x);
}

vec3 hsv2rgb(in vec3 c)
{
	vec3 rgb = clamp(abs(mod(c.x * 6.0 + vec3(0.0, 4.0, 2.0), 6.0) - 3.0) - 1.0, 0.0, 1.0);

	return c.z * mix(vec3(1.0), rgb, c.y);
}





vec4 rgb_to_cmyk(vec3 col) {
	float a = max(col.r, max(col.g, col.b));
	return vec4((a - col.rgb) / a, 1.0 - a);
}

vec3 cmyk_to_rgb(vec4 col) {
	float ik = 1.0 - col.w;
	return (1.0 - col.rgb) * ik;
}

float ht(vec2 uv) {
	uv = fract(uv);
	return pow(length(uv - 0.5) / sqrt(0.5), 1.7);
}

vec2 rotate(vec2 p, float a) {
	float c = cos(a);
	float s = sin(a);
	return vec2(c * p.x + s * p.y, c * p.y - s * p.x);
}

vec4 cmyk_ht(vec2 uv) {
	return vec4(
		ht(rotate(uv, radians(15.0))),
		ht(rotate(uv, radians(75.0))),
		ht(rotate(uv, radians(0.0))),
		ht(rotate(uv, radians(45.0))));
}

vec3 scene(vec2 fragCoord) {
	vec2 uv = fragCoord / iResolution.xy * 2.0 - 1.0;
	uv.x *= iResolution.x / iResolution.y;

	float s = iResolution.y / 10.0;
	vec2 suv = uv * s;
	vec4 htp = cmyk_ht(suv);

	vec4 col = texture(texture2d, uv * vec2(0.282, 0.5) + 0.5) + 1.0 / 255.0;
	col *= 1.0 + 0.1 * sin(uv.x * 5.0 + 4.0 * ttime);
	vec4 cmyk = rgb_to_cmyk(col.rgb);

	cmyk = step(htp, cmyk);

	return clamp(cmyk_to_rgb(cmyk), vec3(0.0), vec3(1.0));
}


void mainImage(out vec4 fragColor, in vec2 fragCoord)
{
	// supersample
	const int N = 2;
	float w = 0.0;
	vec3 c = vec3(0.0);
	for (int x = -N; x <= N; ++x) {
		for (int y = -N; y <= N; ++y) {
			c += scene(fragCoord + vec2(x, y) / (1.5 * float(N)));
			w += 1.0;
		}
	}
	fragColor = vec4(c / w, 1.0);
	//fragColor.xyz*=texture(texture2d,fragCoord/iResolution.xy).xyz;
}
void main(void)
{
	vec4 cl;
	float depth;
	vec2 oUV = UV;


	float SceneSelector = 0.0;

	float ittime = int(ttime * 10) / 10.0;

	vec2 _UV = UV;
	_UV.xy -= 0.5;
	//_UV.xy*=1.0+k0*0.9;
	_UV.xy += 0.5;
	_UV.x += 0.003 * (iqnoise(vec2(15.0 * ittime), 1.0, 1.0) - 0.5);
	_UV.y += 0.003 * (iqnoise(vec2(12.54 * ittime), 1.0, 1.0) - 0.5);

	cl = vec4(texture(texture2d, _UV.xy)).xyzw;
	// dithering
	//if (int(_UV.y * 50) % 2 == 0)

	//if (ttime>2.0-3.0*length (vec2 (16.0/9.0,1.0)*(UV.xy-vec2 (0.5))))	SceneSelector = 1.0;
	//SceneSelector = clamp((ttime - 4.0) * 0.5, 0.0, 1.0);

	vec4 cl0 = texture(texture2dOther, _UV.xy);
	vec4 cl1 = texture(texture2d, _UV.xy);



	if (SceneSelector > 0.5)
		cl = vec4(texture(texture2dOther, _UV.xy)).xyzw;


	//cl = cl0 + (cl1 - cl0) * SceneSelector;


//	cl = vec4(texture(texture2d, _UV.xy)).xyzw


	cl = clamp(cl, vec4(0.0), vec4(1.0));

	/*
	cl.xyz *= vec3(1.0) + vec3(0.3) * iqnoise(vec2(5.0 * ittime) + 0.5 * _UV.xy * vec2(1.66, 1.0), 1.0, 1.0);
	cl *= 1.0 - 0.8 * pow(length((_UV.xy - vec2(0.5)) * vec2(16.0 / 9.0, 1.0)), 5.0);
	*/

	float shadow;
	if (SceneSelector < 0.5)
		shadow = Shadow(texturedepth, _UV.xy);
	else
		shadow = Shadow(texture2dOtherdepth, _UV.xy);

	cl *= shadow;


	//water
	if (0==1) 
	if (_UV.y < 0.5)
	{
		vec2 UVV = _UV.xy;
		//UVV.x *= 0.8;
		//UVV.x += 0.02*sin(ttime + 142.0*UVV.y);

		UVV.y += (0.5 - UVV.y) * sin(UVV.y * 20.0 + 1.32 * ttime) * 0.04;
		UVV.x += (0.5 - UVV.y) * sin(UVV.y * 60.0 + 4.0 * ttime) * 0.02;

		cl = (UVV.y)*vec4(0.5, 0.8, 1, 1) * texture(texture2d, vec2(UVV.x, 1.0 - UVV.y)).xyzw;
		//cl += vec4(0.3, 1.0, 1, 1) * texture(texture2d, vec2(UVV.x, 1.0 - UVV.y)).xyzw;
		//cl*= 0.9+0.3*sin(sin(UVV.x*5.0)*UVV.y * 400.0 + 1.32 * ttime) * 0.5;

	}

	/*
cl = vec4(texture(texture2dOther, _UV.xy)).xyzw;
if (int (_UV.y*70)%2==0)
cl = vec4(texture(texture2d, _UV.xy)).xyzw;
*/
// final paper

//	mainImage( cl, _UV.xy*vec2 (1920.0,1080.0));
	//cl *= 2.0;
	if (ttime <= 30.0)

	if (ttime >= 25.0) {


		if (clamp ((UV.x-0.5),0.0,1.0) > (ttime - 25.0))
			cl *= 0.0;
		
		if (clamp((1.0-UV.x - 0.5), 0.0, 1.0) >(ttime - 25.0))
			cl *= 0.0;
	};



	if (ttime >= 65.0) {


		if (clamp((UV.x - 0.5), 0.0, 1.0) > (ttime - 65.0))
			cl *= 0.0;

		if (clamp((1.0 - UV.x - 0.5), 0.0, 1.0) > (ttime - 65.0))
			cl *= 0.0;
	};

	if (ttime <= 36.0)

	if (ttime >= 33.0) {


		if (clamp((UV.x - 0.5), 0.0, 1.0) > (ttime - 33.0))
			cl *= 0.0;

		if (clamp((1.0 - UV.x - 0.5), 0.0, 1.0) > (ttime - 33.0))
			cl *= 0.0;
	};
	if (ttime <= 20.0)

	if (ttime >= 17.0) {


		if (clamp((UV.x - 0.5)- 0.276 +0.5 * UV.y, 0.0, 1.0) > (ttime - 17.0))
			cl *= 0.0;

		if (clamp((1.0 - UV.x - 0.5) - 0.276+0.5*UV.y, 0.0, 1.0) > (ttime - 17.0))
			cl *= 0.0;
	};


	if (ttime >= 49.0) {


		if (clamp((UV.x - 0.5) - 0.276 + 0.5 * UV.y, 0.0, 1.0) > (ttime - 49.0))
			cl *= 0.0;

		if (clamp((1.0 - UV.x - 0.5) - 0.276 + 0.5 * UV.y, 0.0, 1.0) > (ttime - 49.0))
			cl *= 0.0;
	};

	if (ttime<=60.0)
	if (ttime >= 57.0) {


		if (clamp((UV.x - 0.5) - 0.226 + 0.5 * UV.y, 0.0, 1.0) > (ttime - 57.0))
			cl *= 0.0;

		if (clamp((1.0 - UV.x - 0.5) - 0.226 + 0.5 * UV.y, 0.0, 1.0) > (ttime - 57.0))
			cl *= 0.0;
	};


	if (ttime >= 61.0) {


		if (clamp((UV.x - 0.5) - 0.226 + 0.5 * UV.y, 0.0, 1.0) > (ttime - 61.0))
			cl *= 0.0;

		if (clamp((1.0 - UV.x - 0.5) - 0.226 + 0.5 * UV.y, 0.0, 1.0) > (ttime - 61.0))
			cl *= 0.0;
	};




	if (ttime >= 257.0) {


		if (clamp((UV.x - 0.5) - 0.006 + 0.5 * UV.y, 0.0, 1.0) > (ttime - 257.0))
			cl *= 0.0;

		if (clamp((1.0 - UV.x - 0.5) - 0.006 + 0.5 * UV.y, 0.0, 1.0) > (ttime - 257.0))
			cl *= 0.0;
	};



	if (ttime >= 265.0) {


		if (clamp((UV.x - 0.5) - 0.006 + 0.5 * UV.y, 0.0, 1.0) > 2.0 *  (ttime - 265.0))
			cl *= 0.0;

		if (clamp((1.0 - UV.x - 0.5) - 0.006 + 0.5 * UV.y, 0.0, 1.0) > 2.0 * (ttime - 265.0))
			cl *= 0.0;
	};


	if (ttime >= 273.0) {


		if (clamp((UV.x - 0.5) - 0.076 + 0.5 * UV.y, 0.0, 1.0) > 2.0*(ttime - 273.0))
			cl *= 0.0;

		if (clamp((1.0 - UV.x - 0.5) - 0.076 + 0.5 * UV.y, 0.0, 1.0) > 2.0 * (ttime - 273.0))
			cl *= 0.0;
	};





	if (ttime < 81.0)
		if (ttime >= 77.0) {


			if (clamp((UV.x - 0.5) - 0.226 + 0.5 * UV.y, 0.0, 1.0) > (ttime - 77.0))
				cl *= 0.0;

			if (clamp((1.0 - UV.x - 0.5) - 0.226 + 0.5 * UV.y, 0.0, 1.0) > (ttime - 77.0))
				cl *= 0.0;

			cl.xyz = rgb2hsv(cl.xyz);
			cl.y += 1.0 * 0.95 * (1.0 - clamp((ttime - 77.0 - UV.y * 0.1) * 0.3, 0.0, 1.0));
			cl.x += 0.2 * 0.95 * (1.0 - clamp((ttime - 77.0 - UV.y * 0.1) * 0.3, 0.0, 1.0));
			cl.xyz = hsv2rgb(cl.xyz);

		};



	if (ttime < 89.0)
		if (ttime >= 85.0) {


			if (clamp((UV.x - 0.5) - 0.226 + 0.5 * UV.y, 0.0, 1.0) > (ttime - 85.0))
				cl *= 0.0;

			if (clamp((1.0 - UV.x - 0.5) - 0.226 + 0.5 * UV.y, 0.0, 1.0) > (ttime - 85.0))
				cl *= 0.0;
			
			cl.xyz = rgb2hsv(cl.xyz);
			cl.y += 1.0 * 0.95 * (1.0 - clamp((ttime - 85.0 - UV.y * 0.1) * 0.3, 0.0, 1.0));
			cl.x -= 0.2 * 0.95 * (1.0 - clamp((ttime - 85.0 - UV.y * 0.1) * 0.3, 0.0, 1.0));
			cl.xyz *= 1.0 + 1.0 * (1.0-clamp((ttime - 85.0), 0.0, 1.0));
			cl.xyz = hsv2rgb(cl.xyz);
			
		};

	if (ttime < 75.0)
		if (ttime >= 69.0) {


			//if (clamp((UV.x - 0.5) - 0.226 + 0.5 * UV.y, 0.0, 1.0) > (ttime - 77.0))				cl *= 0.0;

			//if (clamp((1.0 - UV.x - 0.5) - 0.226 + 0.5 * UV.y, 0.0, 1.0) > (ttime - 77.0))				cl *= 0.0;

			cl.xyz = rgb2hsv(cl.xyz);
			
			cl.y += 0.1 * 0.95 * (1.0 - clamp((cl.x+ttime - 69.0 - UV.y * 0.1) * 0.3, 0.0, 1.0));
			cl.x += 0.05 * 0.95 * (1.0 - clamp((cl.x + ttime - 69.0 - UV.y * 0.1) * 0.3, 0.0, 1.0));
			//if (UV.x>0.118)				if (UV.x<0.858)		
			cl *= 1.0+5.0*(1.0-clamp((ttime - 69.0)*1.0, 0.0, 1.0))*1.0;
			
			cl.xyz = hsv2rgb(cl.xyz);
			cl.xyz += (cl.xyz*3.0+vec3 (0.3)) * (1.0 - clamp((ttime - 69.0) * 1.0, 0.0, 1.0)) * 1.0;

		};




	if (ttime<84.0)
	if (ttime >= 81.0) {


		if (clamp((UV.x - 0.5) - 0.226 + 0.5 * UV.y, 0.0, 1.0) > (ttime - 81.0))
			cl *= 0.0;

		if (clamp((1.0 - UV.x - 0.5) - 0.226 + 0.5 * UV.y, 0.0, 1.0) > (ttime - 81.0))
			cl *= 0.0;
	};


	if (ttime<76.0)
	if (ttime >= 73.0) {


		if (clamp((UV.x - 0.5) - 0.226 + 0.5 * UV.y, 0.0, 1.0) > (ttime - 73.0))
			cl *= 0.0;

		if (clamp((1.0 - UV.x - 0.5) - 0.226 + 0.5 * UV.y, 0.0, 1.0) > (ttime - 73.0))
			cl *= 0.0;

		if (clamp((1.0 - UV.x - 0.5) - 0.226 + 0.5 *(1.0- UV.y), 0.0, 1.0) > (ttime - 73.0))
			cl *= 0.0;
		if (clamp((UV.x - 0.5) - 0.226 + 0.5 * (1.0-UV.y), 0.0, 1.0) > (ttime - 73.0))
			cl *= 0.0;

	};

	if (ttime<93.0)
	if (ttime >= 89.0) {
		float tt = 89.0;
		if (clamp((UV.x - 0.5) - 0.226 + 0.5 * UV.y, 0.0, 1.0) > (ttime - tt))
			cl *= 0.0;
	if (clamp((1.0 - UV.x - 0.5) - 0.226 + 0.5 * UV.y, 0.0, 1.0) > (ttime - tt))
			cl *= 0.0;
		if (clamp((1.0 - UV.x - 0.5) - 0.226 + 0.5 * (1.0 - UV.y), 0.0, 1.0) > (ttime - tt))
			cl *= 0.0;
		if (clamp((UV.x - 0.5) - 0.226 + 0.5 * (1.0 - UV.y), 0.0, 1.0) > (ttime - tt))
			cl *= 0.0;
	};


	if (ttime < 103.0)
		if (ttime >= 97.0) {
			float tt = 96.9;
			if (clamp((UV.x - 0.5) - 0.226 + 0.5 * UV.y, 0.0, 1.0) > (ttime - tt))
				cl *= 0.0;
			if (clamp((1.0 - UV.x - 0.5) - 0.226 + 0.5 * UV.y, 0.0, 1.0) > (ttime - tt))
				cl *= 0.0;
			if (clamp((1.0 - UV.x - 0.5) - 0.226 + 0.5 * (1.0 - UV.y), 0.0, 1.0) > (ttime - tt))
				cl *= 0.0;
			if (clamp((UV.x - 0.5) - 0.226 + 0.5 * (1.0 - UV.y), 0.0, 1.0) > (ttime - tt))
				cl *= 0.0;
		};


	if (ttime < 116.0)
		if (ttime >= 113.0) {
			float tt = 113.0;
			if (clamp((UV.x - 0.5) - 0.226 + 0.5 * UV.y, 0.0, 1.0) > (ttime - tt))
				cl *= 0.0;
			if (clamp((1.0 - UV.x - 0.5) - 0.226 + 0.5 * UV.y, 0.0, 1.0) > (ttime - tt))
				cl *= 0.0;
			if (clamp((1.0 - UV.x - 0.5) - 0.226 + 0.5 * (1.0 - UV.y), 0.0, 1.0) > (ttime - tt))
				cl *= 0.0;
			if (clamp((UV.x - 0.5) - 0.226 + 0.5 * (1.0 - UV.y), 0.0, 1.0) > (ttime - tt))
				cl *= 0.0;
		};




	if (TheType > 0.5) {

		if (ttime < 145.0)
			if (ttime >= 141.0) {




				float tt = 141.0;






				cl.xyz = rgb2hsv(cl.xyz);
				//		cl.x = k0; // (ttime - 142.0) * 1;
	//				cl.y += (1.0 - cl.y) * 0.8 * clamp((ttime - 233 - UV.y * 0.5) * 0.3, 0.0, 1.0);
					//cl.z *= clamp((ttime - 233.0) * 1.0, 0.0, 1.0);
				cl.y += 3.0; // -clamp((ttime - 141.0) * 0.5, 0.0, 1.0);
				//cl.z += (1.0 - clamp((ttime - 141.0) * 0.5, 0.0, 1.0))*0.5;
				//cl.y += 3.0;
				//cl.y = 0.0;
				cl.xyz = hsv2rgb(cl.xyz);
				cl.xyz *= 14.0 - 13.0 * clamp((ttime - 141.0) * 0.25, 0.0, 1.0);
			};

	};




	if (ttime >= 149.0)
		if (ttime < 153.0) {





			float tt = 149.0;
			if (clamp((UV.x - 0.5) - 0.226 + 0.5 * UV.y, 0.0, 1.0) > (ttime - tt)*0.5)
				cl *= 0.0;
			if (clamp((1.0 - UV.x - 0.5) - 0.226 + 0.5 * UV.y, 0.0, 1.0) > (ttime - tt) * 0.5)
				cl *= 0.0;
			if (clamp((1.0 - UV.x - 0.5) - 0.226 + 0.5 * (1.0 - UV.y), 0.0, 1.0) > (ttime - tt) * 0.5)
				cl *= 0.0;
			if (clamp((UV.x - 0.5) - 0.226 + 0.5 * (1.0 - UV.y), 0.0, 1.0) > (ttime - tt) * 0.5)
				cl *= 0.0;



			cl.xyz = rgb2hsv(cl.xyz);
			//		cl.x = k0; // (ttime - 142.0) * 1;
//				cl.y += (1.0 - cl.y) * 0.8 * clamp((ttime - 233 - UV.y * 0.5) * 0.3, 0.0, 1.0);
				//cl.z *= clamp((ttime - 233.0) * 1.0, 0.0, 1.0);
			cl.y += -5.0 * (1.0 - clamp((ttime - 149.0) * 0.5, 0.0, 1.0));
			cl.x += -1.0 * (1.0 - clamp((ttime - 150.0) * 0.5, 0.0, 1.0));
			//cl.z += (1.0 - clamp((ttime - 141.0) * 0.5, 0.0, 1.0))*0.5;
			//cl.y += 3.0;
			//cl.y = 0.0;
		//	cl.z *= clamp((ttime - 149.0-UV.y) * 0.5, 0.0, 1.0);
			cl.xyz = hsv2rgb(cl.xyz);
		//	cl.xyz *= 14.0 - 13.0 * clamp((ttime - 149.0) * 0.25, 0.0, 1.0);
		};



	if (ttime < 146.0)
		if (ttime >= 137.0) {
			float tt = 137.0;
			if (clamp((UV.x - 0.5) - 0.226 + 0.5 * UV.y, 0.0, 1.0) > (ttime - tt))
				cl *= 0.0;
			if (clamp((1.0 - UV.x - 0.5) - 0.226 + 0.5 * UV.y, 0.0, 1.0) > (ttime - tt))
				cl *= 0.0;
			if (clamp((1.0 - UV.x - 0.5) - 0.226 + 0.5 * (1.0 - UV.y), 0.0, 1.0) > (ttime - tt))
				cl *= 0.0;
			if (clamp((UV.x - 0.5) - 0.226 + 0.5 * (1.0 - UV.y), 0.0, 1.0) > (ttime - tt))
				cl *= 0.0;
		};
	if (ttime < 146.0)
		if (ttime >= 141.0) {
			float tt = 141.0;
			if (clamp((UV.x - 0.5) - 0.226 + 0.5 * UV.y, 0.0, 1.0) > (ttime - tt))
				cl *= 0.0;
			if (clamp((1.0 - UV.x - 0.5) - 0.226 + 0.5 * UV.y, 0.0, 1.0) > (ttime - tt))
				cl *= 0.0;
			if (clamp((1.0 - UV.x - 0.5) - 0.226 + 0.5 * (1.0 - UV.y), 0.0, 1.0) > (ttime - tt))
				cl *= 0.0;
			if (clamp((UV.x - 0.5) - 0.226 + 0.5 * (1.0 - UV.y), 0.0, 1.0) > (ttime - tt))
				cl *= 0.0;
		};


	if (ttime < 180.0)
		if (ttime >= 177.0) {
			float tt = 177.0;
			if (clamp((UV.x - 0.5) - 0.226 + 0.5 * UV.y, 0.0, 1.0) > (ttime - tt))
				cl *= 0.0;
			if (clamp((1.0 - UV.x - 0.5) - 0.226 + 0.5 * UV.y, 0.0, 1.0) > (ttime - tt))
				cl *= 0.0;
			if (clamp((1.0 - UV.x - 0.5) - 0.226 + 0.5 * (1.0 - UV.y), 0.0, 1.0) > (ttime - tt))
				cl *= 0.0;
			if (clamp((UV.x - 0.5) - 0.226 + 0.5 * (1.0 - UV.y), 0.0, 1.0) > (ttime - tt))
				cl *= 0.0;
		};


	if (ttime < 180.0)
		if (ttime >= 169.0) {
			float tt = 169.0;
			if (clamp((UV.x - 0.5) - 0.226 + 0.5 * UV.y, 0.0, 1.0) > (ttime - tt))
				cl *= 0.0;
			if (clamp((1.0 - UV.x - 0.5) - 0.226 + 0.5 * UV.y, 0.0, 1.0) > (ttime - tt))
				cl *= 0.0;
			if (clamp((1.0 - UV.x - 0.5) - 0.226 + 0.5 * (1.0 - UV.y), 0.0, 1.0) > (ttime - tt))
				cl *= 0.0;
			if (clamp((UV.x - 0.5) - 0.226 + 0.5 * (1.0 - UV.y), 0.0, 1.0) > (ttime - tt))
				cl *= 0.0;
		};

	if (ttime < 220.0)
		if (ttime >=209.0) {
			float tt = 209.0;
			if (clamp((UV.x - 0.5) - 0.226 + 0.5 * UV.y, 0.0, 1.0) > (ttime - tt))
				cl *= 0.0;
			if (clamp((1.0 - UV.x - 0.5) - 0.226 + 0.5 * UV.y, 0.0, 1.0) > (ttime - tt))
				cl *= 0.0;
			//if (clamp((1.0 - UV.x - 0.5) - 0.226 + 0.5 * (1.0 - UV.y), 0.0, 1.0) > (ttime - tt))				cl *= 0.0;
			//if (clamp((UV.x - 0.5) - 0.226 + 0.5 * (1.0 - UV.y), 0.0, 1.0) > (ttime - tt))				cl *= 0.0;
		};


	if (ttime < 220.0)
		if (ttime >= 217.0) {
			float tt = 217.0;
			if (clamp((UV.x - 0.5) - 0.226 + 0.5 * UV.y, 0.0, 1.0) > (ttime - tt))
				cl *= 0.0;
			if (clamp((1.0 - UV.x - 0.5) - 0.226 + 0.5 * UV.y, 0.0, 1.0) > (ttime - tt))
				cl *= 0.0;
			if (clamp((1.0 - UV.x - 0.5) - 0.226 + 0.5 * (1.0 - UV.y), 0.0, 1.0) > (ttime - tt))				cl *= 0.0;
			if (clamp((UV.x - 0.5) - 0.226 + 0.5 * (1.0 - UV.y), 0.0, 1.0) > (ttime - tt))				cl *= 0.0;
		};


	if (ttime < 230.0)
		if (ttime >= 225.0) {
			float tt = 225.0;
			if (clamp((UV.x - 0.5) - 0.226 + 0.5 * UV.y, 0.0, 1.0) > (ttime - tt))
				cl *= 0.0;
			if (clamp((1.0 - UV.x - 0.5) - 0.226 + 0.5 * UV.y, 0.0, 1.0) > (ttime - tt))
				cl *= 0.0;
			if (clamp((1.0 - UV.x - 0.5) - 0.226 + 0.5 * (1.0 - UV.y), 0.0, 1.0) > (ttime - tt))				cl *= 0.0;
			if (clamp((UV.x - 0.5) - 0.226 + 0.5 * (1.0 - UV.y), 0.0, 1.0) > (ttime - tt))				cl *= 0.0;
		};



	if (ttime < 250.0)
		if (ttime >= 241.0) {
			float tt = 241.0;
			if (clamp((UV.x - 0.5) - 0.226 + 0.5 * UV.y, 0.0, 1.0) > (ttime - tt))
				cl *= 0.0;
			if (clamp((1.0 - UV.x - 0.5) - 0.226 + 0.5 * UV.y, 0.0, 1.0) > (ttime - tt))
				cl *= 0.0;
			if (clamp((1.0 - UV.x - 0.5) - 0.226 + 0.5 * (1.0 - UV.y), 0.0, 1.0) > (ttime - tt))				cl *= 0.0;
			if (clamp((UV.x - 0.5) - 0.226 + 0.5 * (1.0 - UV.y), 0.0, 1.0) > (ttime - tt))				cl *= 0.0;
		};

	if (ttime >= 277.0) {
		cl *= 1.0 - clamp((ttime - 277) * 0.25, 0.0, 1.0);

	}

		if (ttime >= 249.0) {
			float tt = 249.0;
			if (clamp((UV.x - 0.5) - 0.226 + 0.5 * UV.y, 0.0, 1.0) > (ttime - tt))
				cl *= 0.0;
			if (clamp((1.0 - UV.x - 0.5) - 0.226 + 0.5 * UV.y, 0.0, 1.0) > (ttime - tt))
				cl *= 0.0;
			if (clamp((1.0 - UV.x - 0.5) - 0.226 + 0.5 * (1.0 - UV.y), 0.0, 1.0) > (ttime - tt))				cl *= 0.0;
			if (clamp((UV.x - 0.5) - 0.226 + 0.5 * (1.0 - UV.y), 0.0, 1.0) > (ttime - tt))				cl *= 0.0;
		};


	if (ttime >=0.0) {


		if (clamp((UV.x - 0.5) - 0.0 + 0.0 * UV.y, 0.0, 1.0) > (ttime - 0.0))
			cl *= 0.0;

		if (clamp((1.0 - UV.x - 0.5) - 0.0 + 0.0 * UV.y, 0.0, 1.0) > (ttime - 0.0))
			cl *= 0.0;
	};




	if (ttime<145.0)
	if (ttime >= 141.0) {

		cl.xyz=rgb2hsv(cl.xyz);
//		cl.x = k0; // (ttime - 142.0) * 1;
		cl.y += (1.0 - cl.y) * 0.8*clamp((ttime - 141.0-UV.y*0.5) * 0.3, 0.0, 1.0);
		cl.x += (0.575 - cl.x) * 0.95 * clamp((ttime - 141.0 - UV.y * 0.5) * 0.8, 0.0, 1.0);
		cl.z *= 1.0+3.0*0.15 * clamp((ttime - 141.0 - UV.y * 0.5) * 0.3, 0.0, 1.0);
		cl.xyz = hsv2rgb(cl.xyz);
		//cl.xyz = hsv2rgb(vec3(0.0*length(oUV.xy - vec2(0.5))+cl.z * 0.6-k0-0.333+cl.w*0.0,0.7,		cl.x));

	};

	//cl.xyz = hsv2rgb(vec3(0.0*length(oUV.xy - vec2(0.5))+cl.z * 0.6-k0-0.333+cl.w*0.0,0.7,		cl.x));

//	cl.xyz=bl
	//cl.x = 0;
	if (ttime >= 161.0)
	if (ttime<169.0)
	{
		float beat = 0.5 + 0.5 * sin(0.4 + ttime * 3.1415926535 * 1.0 * 120.0 / 60.0);
		beat = 1.0 - beat;
		beat = pow(beat, 3.0);
		beat *= beat * 0.5;
		beat = 1.0 + beat; // +clamp(beat, 0.0, 1.0);
		cl *= beat;
	}
	


	if (TheType > 0.5) {

			if (ttime >= 233.0) {
				
				
				
				
				float tt = 233.0;
				if (clamp((UV.x - 0.5) - 0.226 + 0.5 * UV.y, 0.0, 1.0) > (ttime - tt))
					cl *= 0.0;
				if (clamp((1.0 - UV.x - 0.5) - 0.226 + 0.5 * UV.y, 0.0, 1.0) > (ttime - tt))
					cl *= 0.0;
				if (clamp((1.0 - UV.x - 0.5) - 0.226 + 0.5 * (1.0 - UV.y), 0.0, 1.0) > (ttime - tt))				cl *= 0.0;
				if (clamp((UV.x - 0.5) - 0.226 + 0.5 * (1.0 - UV.y), 0.0, 1.0) > (ttime - tt))				cl *= 0.0;

				
				
				
				
				
				
				
				cl.xyz = rgb2hsv(cl.xyz);
				//		cl.x = k0; // (ttime - 142.0) * 1;
//				cl.y += (1.0 - cl.y) * 0.8 * clamp((ttime - 233 - UV.y * 0.5) * 0.3, 0.0, 1.0);
				//cl.z *= clamp((ttime - 233.0) * 1.0, 0.0, 1.0);
				cl.y +=1.0- clamp((ttime - 233.0) * 1.5, 0.0, 1.0);
				//cl.y += 3.0;
				cl.xyz = hsv2rgb(cl.xyz);
			};

	};








	if (ttime>=89)
		if (ttime < 97.0)
		{
			

			float beat = 0.5 + 0.5 * sin(0.8 + cl.x * 0.1 + 0.02 * UV.x + 0.0 * depth + 0.417 + fttime * 3.1415926535 * 1.0 * 120.0 / 60.0);
			beat = 1.0 - beat;
			beat = pow(beat, 24.0);
			//beat = pow(beat, 8.0);

			//beat *= beat;

			beat = 0.0 + 0.7 * beat; // +clamp(beat, 0.0, 1.0);
			
			float dist = 1.0-clamp(length(UV.xy - vec2(0.827, 0.323)), 0.0, 1.0);
			
			
			if (int(ttime+0.56) % 2 == 0)
	 dist = 1.0 - clamp(length(UV.xy - vec2(0.386, 0.323)), 0.0, 1.0);

			//if (int (ttim
			
			float distt = pow(dist, 5.0);
			dist = pow(dist, 14.0);

			cl.xyz += cl.xyz * beat * dist * 51.5 * vec3(1, 0.8, 0.6);
//			cl.xyz +=  beat * distt * 1.0 * vec3(1, 0.6, 0.4);
			//cl.xyz = vec3(dist);

			//cl.x=0.0;
			//cl.xyz = vec3(dist);
		}



	if (ttime >= 150.0)
		if (ttime < 160.5) //153
		{

			float fract =0.717+1.0* 3. + 1.0*3.14159 / 2.0 + 0.9 + cl.x * 0.1 + 0.02 * UV.x + 0.0 * depth + 0.417 + fttime * 3.1415926535 * 1.0 * 120.0 / 60.0;
			//fract += 2 * 3.1416;
			fract = mod(fract, 2 * 3.1416);
			//fract -= 
			
				


			float beat = 0.5 + 0.5 * sin(fract);
			
			//beat = 1.0 - beat;
			beat = pow(beat, 2.5);

			//if (fract < 3.14159 * 0.5)
				if (fract > 3.14159*0.5)

				beat = 1.0;
				beat = 1.0 - beat;
			//beat = pow(beat, 8.0);

			//beat *= beat;

			beat = 0.0 + 0.7 * beat; // +clamp(beat, 0.0, 1.0);

			float dist = 1.0 - clamp(length(UV.xy - vec2(0.827, 0.323)), 0.0, 1.0);
			dist = UV.x;


			if (int(3.14159 / 2.0 + ttime + 0.56) % 2 == 1)
				dist = 1.0 - UV.x; // clamp(length(UV.xy - vec2(0.386, 0.323)), 0.0, 1.0);

			dist *= 1.0;
			dist = clamp(dist, 0.0, 1.0);
			//if (int (ttim
			beat *= 0.2;
			//dist = pow(dist, 2.0);
			beat *= clamp((ttime - 146.0)*0.3, 0.0, 1.0);
			cl.xyz += cl.xyz * beat * dist * 20.5 * vec3(1, 0.7, 0.5);
			cl.xyz += clamp((ttime - 145.0) * 0.3, 0.0, 1.0)* beat * dist *(1.0-UV.y)* 2.5 * vec3(1, 0.45, 0.2);
			//cl.xyz = vec3(dist);
			if (ttime >= 153.0) {

				cl.xyz += UV.x *UV.x*beat* vec3(1.0, 1.0, 1.0)*3.0*(cl.xyz+vec3 (0.2));
			}
		//	cl.xyz = vec3(beat);
			//cl.x=0.0;
			//cl.xyz = vec3(dist);
		}


	if (ttime>=169.0)
	if (ttime<204.0)
	{


		float depth = texture(texturedepth, oUV.xy).w;
		depth = pow(depth, 90.0);

		float beat = 0.5 + 0.5 * sin(0.5+cl.x*0.1+0.02*UV.x+0.0*depth+0.417 + fttime * 3.1415926535 * 1.0 * 120.0 / 60.0);
		beat = 1.0 - beat;
		beat = pow(beat, 24.0);
		//beat = pow(beat, 8.0);

		//beat *= beat;
		beat = 0.0 + 0.7*beat; // +clamp(beat, 0.0, 1.0);
		cl.xyz = rgb2hsv(cl.xyz);
		//		cl.x = k0; // (ttime - 142.0) * 1;
		//cl.x += beat;
		//cl.y += beat;
		//l.z += beat * 0.2;
		//cl.z += beat;
		//cl.y += (1.0 - cl.y) * 0.8 * clamp((ttime - 141.0 - UV.y * 0.5) * 0.3, 0.0, 1.0);
		cl.xyz = hsv2rgb(cl.xyz);
		cl.xyz += cl.xyz * beat * 1.2;
		
//		cl +=cl*beat;
		//cl.xyz = vec3(beat);
		//cl.xyz = vec3(depth);
	}




	/*
	if (ttime >= 203.8)
	{


		float depth = texture(texturedepth, oUV.xy).w;
		depth = pow(depth, 90.0);
		depth = clamp(depth, 0.7, 1.0);
		cl.xyz+= vec3(1.0,1.0,1.0)*(1.0 - clamp((ttime - oUV.x*0.0 -203.8+k1*8.0 - 8.0*depth) * 0.3, 0.0, 1.0));
	}
	*/


	if (ttime > 270) {
		cl.xyz *= 1.0-clamp((ttime - 270.0) * 0.4, 0.0, 1.0);

	}




	gl_FragData[0] = cl;
	gl_FragData[1] = cl;
	//if (texture(texturedepth, oUV.xy).w >  0.999) gl_FragData[0]=vec4 (1,0,0,1);

}














